/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.auiml.databeans.updates.NonDisruptiveFirmwareUpdateBean;
import com.ibm.hsc.websm.updates.FirmwareUpdateConstants;
import com.ibm.hsc.websm.updates.PIUpdateErrorIds;
import com.ibm.hsc.websm.updates.PIUpdater;
import com.ibm.hsc.websm.updates.PIUpdatesOwner;
import com.ibm.hsc.websm.updates.UpdatePanelUtilities;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.report.IntermediateReport;
import com.ibm.hwmca.fw.report.StepReport;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressListener;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdaterEvent;
import com.ibm.hwmca.xfw.updates.UpdaterListener;

public class NonDisruptiveFirmwareUpdateTasklet
extends HwmcaPanelTasklet
implements FirmwareUpdateConstants,
PIUpdateErrorIds,
UpdaterListener,
ProgressEndedListener {
    private static final String TRACE_MASKT = "XUPDNDTT";
    private static final String TRACE_MASKF = "XUPDNDTF";
    private static final String TRACE_MASKD = "XUPDNDTD";
    private ObjectId[] targetIds;
    private ManagedObject[] initialTargets;
    private ManagedObject[] currentTargets;
    boolean isCECFSP;
    boolean isPartition;
    boolean isPHYP;
    boolean isBPCFSP;
    private boolean progressDismissed;
    private ProgressReportListenerImpl reportListener = null;
    private static final String PROGRESS_PANEL_ID = "NondisFirmwareUpdProgID";
    private static FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "NonDisruptiveFirmwareUpdateTasklet");

    public NonDisruptiveFirmwareUpdateTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NonDisruptiveFirmwareUpdateTasklet constructor");
        this.setExplicitTerminate(true);
        Trace.trace((String)TRACE_MASKT, (Object)"<- NonDisruptiveFirmwareUpdateTasklet constructor");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NonDisruptiveFirmwareUpdateTasklet.service()");
        if (panelTaskletRequest.isInitialRequest()) {
            Trace.trace((String)TRACE_MASKF, (Object)"Initial Request");
            this.targetIds = this.getPresentationTaskParms().getTargetIds();
            this.initialTargets = (ManagedObject[])this.getObjectsForIds(this.targetIds);
            this.currentTargets = this.initialTargets;
            NonDisruptiveFirmwareUpdateBean nonDisruptiveFirmwareUpdateBean = new NonDisruptiveFirmwareUpdateBean();
            nonDisruptiveFirmwareUpdateBean.setTargetOutput(new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "STANDARD_TARGETING").toString());
            panelTaskletResponse.replace("com.ibm.hsc.auiml.databeans.updates.FirmwareRes", "NonDisruptiveFirmwareUpdatePanel", (PanelBean)nonDisruptiveFirmwareUpdateBean);
            Trace.trace((String)TRACE_MASKF, (Object)"End Initial Request");
        } else if (null != (String)panelTaskletRequest.getData("terminate")) {
            Trace.trace((String)TRACE_MASKF, (Object)" [NonDisruptiveFirmwareUpdateTasklet.service()] Terminate task because work has completed.");
            panelTaskletResponse.terminate();
        } else if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
            Trace.trace((String)TRACE_MASKF, (Object)"Terminated task because dispose/cancel received.");
            panelTaskletResponse.terminate();
        } else {
            String string = (String)panelTaskletRequest.getData("command");
            Trace.trace((String)TRACE_MASKF, (Object)("Button Name: " + string));
            if (string.endsWith("AdvancedButton")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Handle the Advanced Button");
                panelTaskletResponse.noAction();
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"Handle the OK Button");
                this.isCECFSP = (Boolean)panelTaskletRequest.getData("isCECFSP");
                this.isPartition = (Boolean)panelTaskletRequest.getData("isPartition");
                this.isPHYP = (Boolean)panelTaskletRequest.getData("isPHYP");
                this.isBPCFSP = (Boolean)panelTaskletRequest.getData("isBpcTpggle");
                Trace.trace((String)TRACE_MASKF, (Object)"checkbox selection status -");
                Trace.trace((String)TRACE_MASKF, (Object)("  isCECFSP: " + this.isCECFSP + ", isPartition: " + this.isPartition + ", isPHYP: " + this.isPHYP + ", isBPCFSP: " + this.isBPCFSP));
                Runnable runnable = new Runnable(){

                    public void run() {
                        Trace.trace((String)NonDisruptiveFirmwareUpdateTasklet.TRACE_MASKT, (Object)"-> NonDisruptiveFirmwareUpdateTasklet.runAction.run()");
                        NonDisruptiveFirmwareUpdateTasklet.this.doOperation();
                        Trace.trace((String)NonDisruptiveFirmwareUpdateTasklet.TRACE_MASKT, (Object)"<- NonDisruptiveFirmwareUpdateTasklet.runAction().run()");
                    }
                };
                Trace.trace((String)TRACE_MASKD, (Object)" [NonDisruptiveFirmwareUpdateTasklet.service()] create and start the thread.");
                Thread thread = new Thread(runnable, "NonDisruptiveFirmwareUpdateTasklet install");
                thread.setDaemon(true);
                thread.start();
                Trace.trace((String)TRACE_MASKD, (Object)" [NonDisruptiveFirmwareUpdateTasklet.service()] now close Nondisruptive Firmware Update panel.");
                panelTaskletResponse.dispose();
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- NonDisruptiveFirmwareUpdateTasklet.service()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOperation() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NonDisruptiveFirmwareUpdateTasklet.doOperation()");
        long l = 3600L;
        int n = this.currentTargets.length;
        PIUpdatesOwner[] pIUpdatesOwnerArray = new PIUpdatesOwner[n];
        PIUpdater[] pIUpdaterArray = new PIUpdater[n];
        ProgressData[] progressDataArray = new ProgressData[n];
        ObjectId[] objectIdArray = new ObjectId[n];
        Trace.trace((String)TRACE_MASKF, (Object)(" [NonDisruptiveFirmwareUpdateTasklet.doOperation()] - about to start the action loop for " + n + " managed objects"));
        for (int i = 0; i < n; ++i) {
            objectIdArray[i] = this.targetIds[i];
            pIUpdatesOwnerArray[i] = UpdatePanelUtilities.getPIOwnerForManagedObject(this.currentTargets[i]);
            if (null == pIUpdatesOwnerArray[i]) {
                Trace.trace((String)TRACE_MASKD, (Object)" [NonDisruptiveFirmwareUpdateTasklet.doOperation()] updates owner is null");
                pIUpdaterArray[i] = null;
            } else {
                pIUpdaterArray[i] = (PIUpdater)pIUpdatesOwnerArray[i].getUpdaterInstance();
                pIUpdaterArray[i].addUpdaterListener(this);
                pIUpdaterArray[i].setAttachment(objectIdArray[i]);
            }
            Trace.trace((String)TRACE_MASKD, (Object)(" [NonDisruptiveFirmwareUpdateTasklet.doOperation()] target name is: " + this.currentTargets[i].getUIInfo().getName()));
            progressDataArray[i] = new ProgressData(new LocalizableText(this.currentTargets[i].getUIInfo().getName()), objectIdArray[i], l);
        }
        PanelTaskletProgressListener panelTaskletProgressListener = new PanelTaskletProgressListener((PanelTasklet)this);
        ProgressStartEvent progressStartEvent = new ProgressStartEvent(new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "NONDISRUPT_FIRMWARE_TITLE"), progressDataArray, l, new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "PROGRESS_PANEL_STARTING_OPERATION"), PROGRESS_PANEL_ID, (ProgressCancelListener)null, (ProgressEndedListener)this);
        Trace.trace((String)TRACE_MASKD, (Object)" [NonDisruptiveFirmwareUpdateTasklet.doOperation()] start progress panel");
        panelTaskletProgressListener.startProgress(progressStartEvent);
        this.reportListener = new ProgressReportListenerImpl(PROGRESS_PANEL_ID, objectIdArray, (ProgressListener)panelTaskletProgressListener);
        Trace.trace((String)TRACE_MASKF, (Object)" [NonDisruptiveFirmwareUpdateTasklet.doOperation()] Starting operation for each target object.");
        NonDisruptiveFirmwareUpdateTasklet nonDisruptiveFirmwareUpdateTasklet = this;
        synchronized (nonDisruptiveFirmwareUpdateTasklet) {
            for (int i = 0; i < n; ++i) {
                Trace.trace((String)TRACE_MASKD, (Object)(" [NonDisruptiveFirmwareUpdateTasklet.doOperation()] processing updater #" + i));
                LocalizableText localizableText = null;
                if (null != pIUpdaterArray[i]) {
                    try {
                        Trace.trace((String)TRACE_MASKD, (Object)" [NonDisruptiveFirmwareUpdateTasklet.doOperation()] now issue completeConcurrently()");
                        pIUpdaterArray[i].completeConcurrently(this.isCECFSP, this.isPHYP, this.isPartition, this.isBPCFSP, false);
                        Trace.trace((String)TRACE_MASKD, (Object)" [NonDisruptiveFirmwareUpdateTasklet.doOperation()] back from completeConcurrently()");
                    }
                    catch (HException hException) {
                        Trace.trace((String)TRACE_MASKT, (Object)(" [NonDisruptiveFirmwareUpdateTasklet.doOperation()] caught exception: " + (Object)((Object)hException)));
                        new FrameworkLog(classLogInfo, -1604, (Throwable)hException).log();
                        localizableText = pIUpdaterArray[i].getLastMessage();
                        if (null == localizableText) {
                            localizableText = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "PROGRESS_PANEL_ERROR_PROCESSING");
                        }
                    }
                } else {
                    localizableText = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "PROGRESS_PANEL_CANNOT_UPDATE");
                }
                if (null == localizableText) continue;
                Trace.trace((String)TRACE_MASKD, (Object)(" [NonDisruptiveFirmwareUpdateTasklet.doOperation()] build failure completion report: " + localizableText));
                CompletionReport completionReport = new CompletionReport(objectIdArray[i]);
                completionReport.setCompletionCode(CompletionReportCode.FAIL);
                completionReport.setData((Object)localizableText);
                this.reportListener.completeReport(completionReport);
            }
            this.progressDismissed = false;
            while (!this.progressDismissed) {
                try {
                    Trace.trace((String)TRACE_MASKF, (Object)" [NonDisruptiveFirmwareUpdateTasklet.doOperation()] entering wait()");
                    this.wait();
                    Trace.trace((String)TRACE_MASKF, (Object)" [NonDisruptiveFirmwareUpdateTasklet.doOperation()] leaving wait()");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        Trace.trace((String)TRACE_MASKF, (Object)" [NonDisruptiveFirmwareUpdateTasklet.doOperation()] progress window has been dismissed");
        nonDisruptiveFirmwareUpdateTasklet = new PanelTaskletRequest();
        nonDisruptiveFirmwareUpdateTasklet.setData("terminate", "terminate");
        try {
            this.postRequest(null, (PanelTaskletRequest)nonDisruptiveFirmwareUpdateTasklet);
        }
        catch (TaskletException taskletException) {
            this.logException(taskletException);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- NonDisruptiveFirmwareUpdateTasklet.doOperation()");
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NonDisruptiveFirmwareUpdateTasklet.logException()");
        new FrameworkLog(classLogInfo, -1566, throwable).log();
        Trace.trace((String)TRACE_MASKT, (Object)"<- NonDisruptiveFirmwareUpdateTasklet.logException()");
    }

    public void operationCompleted(UpdaterEvent updaterEvent) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NonDisruptiveFirmwareUpdateTasklet.operationCompleted()");
        PIUpdater pIUpdater = (PIUpdater)updaterEvent.getSource();
        ObjectId objectId = (ObjectId)pIUpdater.getAttachment();
        CompletionReport completionReport = new CompletionReport(objectId);
        int n = updaterEvent.getCompletionStatus();
        LocalizableText localizableText = updaterEvent.getMessage();
        Trace.trace((String)TRACE_MASKF, (Object)("   NonDisruptiveFirmwareUpdateTasklet.operationCompleted()   PIUpdater: [" + pIUpdater + "]," + "   objectId: [" + objectId + "]," + "   status: [" + n + "],"));
        if (null != localizableText) {
            Trace.trace((String)TRACE_MASKF, (Object)("   msg: [" + localizableText + "]"));
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)" [operationCompleted()] The completion message is null.");
        }
        if (44 == n) {
            Trace.trace((String)TRACE_MASKD, (Object)" [operationCompleted()] This is a partially successful completion.");
            completionReport.setCompletionCode(CompletionReportCode.PARTIAL_SUCCESS);
            LocalizableText localizableText2 = updaterEvent.getDetailsMessage();
            if (null != localizableText2) {
                localizableText = localizableText2;
                Trace.trace((String)TRACE_MASKF, (Object)(" [operationCompleted()] The detailed message is '" + localizableText + "'."));
            }
            completionReport.setData((Object)localizableText);
        } else if (2 == n) {
            completionReport.setCompletionCode(CompletionReportCode.FAIL);
            LocalizableText localizableText3 = updaterEvent.getDetailsMessage();
            if (null != localizableText3) {
                localizableText = localizableText3;
                Trace.trace((String)TRACE_MASKF, (Object)(" [operationCompleted()] The detailed message is '" + localizableText + "'."));
            }
            completionReport.setData((Object)localizableText);
        } else {
            completionReport.setCompletionCode(CompletionReportCode.SUCCESS);
            completionReport.setText(localizableText);
        }
        Trace.trace((String)TRACE_MASKD, (Object)(" [operationCompleted()] The UpdaterEvent completion status is: " + n));
        if (null == localizableText) {
            Trace.trace((String)TRACE_MASKD, (Object)" [operationCompleted()] The completion message is null.");
        } else {
            Trace.trace((String)TRACE_MASKD, (Object)(" [operationCompleted()] The completion message is '" + localizableText + "'."));
        }
        this.reportListener.completeReport(completionReport);
        Trace.trace((String)TRACE_MASKT, (Object)"<- NonDisruptiveFirmwareUpdateTasklet.operationCompleted()");
    }

    public void operationProgressing(UpdaterEvent updaterEvent) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NonDisruptiveFirmwareUpdateTasklet.operationProgressing()");
        PIUpdater pIUpdater = (PIUpdater)updaterEvent.getSource();
        ObjectId objectId = (ObjectId)pIUpdater.getAttachment();
        LocalizableText localizableText = new LocalizableText(updaterEvent.getMessage().toString());
        Trace.trace((String)TRACE_MASKF, (Object)("   NonDisruptiveFirmwareUpdateTasklet.operationProgressing()   PIUpdater: [" + pIUpdater + "]," + "   objectId: [" + objectId + "]," + "   msg: [" + localizableText + "]"));
        this.reportListener.intermediateReport((IntermediateReport)new StepReport(objectId, localizableText));
        Trace.trace((String)TRACE_MASKT, (Object)"<- NonDisruptiveFirmwareUpdateTasklet.operationProgressing()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NonDisruptiveFirmwareUpdateTasklet.progressEnded()");
        NonDisruptiveFirmwareUpdateTasklet nonDisruptiveFirmwareUpdateTasklet = this;
        synchronized (nonDisruptiveFirmwareUpdateTasklet) {
            this.progressDismissed = true;
            Trace.trace((String)TRACE_MASKF, (Object)" [NonDisruptiveFirmwareUpdateTasklet.progressEnded()] entering notifyAll()");
            this.notifyAll();
            Trace.trace((String)TRACE_MASKF, (Object)" [progressEnded()] leaving notifyAll()");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- NonDisruptiveFirmwareUpdateTasklet.progressEnded()");
    }
}

